/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.plane;

import math.geom2d.Point2D;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.transform.AffineTransform3D;

public class Plane3D
implements Shape3D {
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    protected double z0 = 0.0;
    protected double dx1 = 1.0;
    protected double dy1 = 0.0;
    protected double dz1 = 0.0;
    protected double dx2 = 0.0;
    protected double dy2 = 1.0;
    protected double dz2 = 0.0;

    public static final Plane3D createXYPlane() {
        return new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0));
    }

    public static final Plane3D createXZPlane() {
        return new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 0.0, 1.0));
    }

    public static final Plane3D createYZPlane() {
        return new Plane3D(new Point3D(0.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, 0.0, 1.0));
    }

    public Plane3D() {
    }

    public Plane3D(Point3D point, Vector3D vector1, Vector3D vector2) {
        this.x0 = point.getX();
        this.y0 = point.getY();
        this.z0 = point.getZ();
        this.dx1 = vector1.getX();
        this.dy1 = vector1.getY();
        this.dz1 = vector1.getZ();
        this.dx2 = vector2.getX();
        this.dy2 = vector2.getY();
        this.dz2 = vector2.getZ();
    }

    public Point3D getOrigin() {
        return new Point3D(this.x0, this.y0, this.z0);
    }

    public Vector3D getVector1() {
        return new Vector3D(this.dx1, this.dy1, this.dz1);
    }

    public Vector3D getVector2() {
        return new Vector3D(this.dx2, this.dy2, this.dz2);
    }

    public Vector3D getNormalVector() {
        return Vector3D.crossProduct(this.getVector1(), this.getVector2()).getOpposite();
    }

    public Point3D getLineIntersection(StraightLine3D line) {
        Vector3D n = this.getNormalVector();
        Vector3D dp = new Vector3D(line.getOrigin(), this.getOrigin());
        double t = Vector3D.dotProduct(n, dp) / Vector3D.dotProduct(n, line.getDirection());
        return line.getPoint(t);
    }

    public Point3D projectPoint(Point3D point) {
        StraightLine3D line = new StraightLine3D(point, this.getNormalVector());
        return this.getLineIntersection(line);
    }

    public Vector3D projectVector(Vector3D vect) {
        Point3D point = new Point3D(this.x0 + vect.getX(), this.y0 + vect.getY(), this.z0 + vect.getZ());
        point = this.projectPoint(point);
        return new Vector3D(point.getX() - this.x0, point.getY() - this.y0, point.getZ() - this.z0);
    }

    public Point3D getPoint(double u, double v) {
        return new Point3D(this.x0 + u * this.dx1 + v * this.dx2, this.y0 + u * this.dy1 + v * this.dy2, this.z0 + u * this.dz1 + v * this.dz2);
    }

    public Point2D getPointPosition(Point3D point) {
        point = this.projectPoint(point);
        return null;
    }

    public Shape3D clip(Box3D box) {
        return null;
    }

    public boolean contains(Point3D point) {
        Point3D proj = this.projectPoint(point);
        return point.getDistance(proj) < 1.0E-12;
    }

    public Box3D getBoundingBox() {
        if (Math.abs(this.dz1) < 1.0E-12 && Math.abs(this.dz2) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.z0, this.z0);
        }
        if (Math.abs(this.dx1) < 1.0E-12 && Math.abs(this.dx2) < 1.0E-12) {
            return new Box3D(this.x0, this.x0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.abs(this.dy1) < 1.0E-12 && Math.abs(this.dy2) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.y0, this.y0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double getDistance(Point3D point) {
        return point.getDistance(this.projectPoint(point));
    }

    public boolean isBounded() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public Shape3D transform(AffineTransform3D trans) {
        return new Plane3D(this.getOrigin().transform(trans), this.getVector1().transform(trans), this.getVector2().transform(trans));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Plane3D)) {
            return false;
        }
        Plane3D plane = (Plane3D)obj;
        if (Math.abs(this.x0 - plane.x0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y0 - plane.y0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.z0 - plane.z0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dx1 - plane.dx1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dy1 - plane.dy1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dz1 - plane.dz1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dx2 - plane.dx2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dy2 - plane.dy2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.dz2 - plane.dz2) > 1.0E-12);
    }
}

